/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class RecoverResources
implements HMCCommands {
    private static final String CPU_TYPE = "cpu";
    private static final String MEMORY_TYPE = "mem";
    private static final String SLOT_TYPE = "slot";
    private HSCCECClient hcc = null;
    private HSCClientObjectFactory hcof;
    private HSCLPARClient hlc = null;
    private String drawerId;
    private String intPartitionName;
    private String managedSystem;
    private String resourceType;
    private String partitionName;
    private String physLoc = null;
    private short processorId = (short)-1;
    private short slotId = (short)-1;
    private Vector recoveryMemInfo;
    private Hashtable recoveryCPUInfo;
    private Vector recoveryIOInfo;

    private int validateMemoryPartitions() throws HSCException {
        Hashtable hashtable = null;
        String string = null;
        this.recoveryMemInfo = this.hcc.getRecoverMemoryData();
        if (null != this.partitionName) {
            HSCLPARClient hSCLPARClient = this.hcof.createLPARClient(this.managedSystem, this.partitionName, false);
            if (null == hSCLPARClient) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
            this.intPartitionName = hSCLPARClient.getIntName();
            for (int i = 0; i < this.recoveryMemInfo.size(); ++i) {
                hashtable = (Hashtable)this.recoveryMemInfo.elementAt(i);
                if (this.intPartitionName.equals((String)hashtable.get("intNames"))) continue;
                return 0;
            }
        } else if (this.recoveryMemInfo != null && this.recoveryMemInfo.size() != 0) {
            return 0;
        }
        return -1;
    }

    private int validateProcessorIds() throws HSCException {
        Object var1_1 = null;
        Short s = null;
        Vector vector = null;
        this.recoveryCPUInfo = this.hcc.getRecoverProcessorData();
        if (-1 != this.processorId) {
            vector = (Vector)this.recoveryCPUInfo.get("stoppedCpuIds");
            for (int i = 0; i < vector.size(); ++i) {
                s = (Short)vector.elementAt(i);
                if (s != this.processorId) continue;
                return 0;
            }
        } else {
            return 0;
        }
        return -1;
    }

    private int validateIOData() throws HSCException {
        Hashtable hashtable = null;
        String string = null;
        String string2 = null;
        Short s = null;
        this.recoveryIOInfo = this.hcc.getRecoverIOData();
        if (null != this.drawerId && -1 != this.slotId) {
            for (int i = 0; i < this.recoveryIOInfo.size(); ++i) {
                hashtable = (Hashtable)this.recoveryIOInfo.elementAt(i);
                string = (String)hashtable.get("IODrawerDeviceID");
                s = (Short)hashtable.get("SlotID");
                if (!string.equals(this.drawerId) || s != this.slotId) continue;
                return 0;
            }
        } else {
            for (int i = 0; i < this.recoveryIOInfo.size(); ++i) {
                hashtable = (Hashtable)this.recoveryIOInfo.elementAt(i);
                string2 = (String)hashtable.get("SlotLocation");
                if (!string2.equals(this.physLoc)) continue;
                this.drawerId = (String)hashtable.get("IODrawerDeviceID");
                this.slotId = (Short)hashtable.get("SlotID");
                return 0;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doRecoverOperation() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        int n = 0;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            n = this.validateMemoryPartitions();
            if (n == -1) {
                objectArray = new String[]{new Integer(n).toString()};
                if (this.partitionName != null) {
                    string = "The partition entered does not require memory recovery.";
                    string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "PARTITION_MEMORY_NOT_REQUIRE_RECOVERY", string, objectArray);
                    throw new HSCException(string2);
                }
                string = "The system entered does not require memory recovery.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "SYSTEM_MEMORY_NOT_REQUIRE_RECOVERY", string, objectArray);
                throw new HSCException(string2);
            }
            Hashtable hashtable = null;
            Vector<String> vector = new Vector<String>();
            if (null == this.partitionName) {
                if (this.recoveryMemInfo == null) {
                    string = "There are no recoverable memory resources in the system.";
                    string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_MEMORY", string, objectArray);
                    throw new HSCException(string);
                }
                for (int i = 0; i < this.recoveryMemInfo.size(); ++i) {
                    hashtable = (Hashtable)this.recoveryMemInfo.elementAt(i);
                    vector.add((String)hashtable.get("partitionNameInt"));
                }
            } else {
                vector.add(this.intPartitionName);
            }
            this.hcc.recoverMemResources(vector);
            return;
        }
        if (this.resourceType.equals(CPU_TYPE)) {
            n = this.validateProcessorIds();
            if (n == -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string = "The processor with the processor ID entered is not a recoverable resource. Please try again.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "PROCESSOR_NOT_RECOVERABLE", string, objectArray);
                throw new HSCException(string);
            }
            Vector vector = new Vector();
            if (-1 == this.processorId) {
                vector = (Vector)this.recoveryCPUInfo.get("stoppedCpuIds");
                if (null == vector || vector.size() == 0) {
                    string = "There are no recoverable processor resources in the system.";
                    string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_PROCESSORS", string, objectArray);
                    throw new HSCException(string);
                }
            } else {
                vector.add(new Short(this.processorId));
            }
            this.hcc.recoverCPUResources(vector);
            return;
        }
        if (!this.resourceType.equals(SLOT_TYPE)) return;
        n = this.validateIOData();
        if (n == -1) {
            objectArray = new String[]{new Integer(n).toString()};
            if (this.physLoc == null) {
                string = "The I/O device  with the slot ID  and drawer ID entered is not a recoverable resource.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "IO_DEVICE_NOT_RECOVERABLE", string, objectArray);
                throw new HSCException(string);
            }
            string = "The I/O device  with the physical location code  entered is not a recoverable resource.";
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "IO_DEVICE_PHYS_LOC_NOT_RECOVERABLE", string, objectArray);
            throw new HSCException(string);
        }
        Hashtable hashtable = null;
        Vector<String> vector = new Vector<String>();
        Vector<Short> vector2 = new Vector<Short>();
        if (null == this.drawerId || -1 == this.slotId) {
            for (int i = 0; i < this.recoveryIOInfo.size(); ++i) {
                hashtable = (Hashtable)this.recoveryIOInfo.elementAt(i);
                vector.add((String)hashtable.get("IODrawerDeviceID"));
                vector2.add((Short)hashtable.get("SlotID"));
            }
            if (null == vector || null == vector2 || vector.size() == 0 || vector2.size() == 0) {
                string = "There are no recoverable I/O resources in the system.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "NO_RECOVERABLE_IO", string, objectArray);
                throw new HSCException(string);
            }
        } else {
            vector.add(this.drawerId);
            vector2.add(new Short(this.slotId));
        }
        this.hcc.recoverIOResources(vector, vector2);
    }

    private void initializeClients() throws HSCException {
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        this.hcof = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = this.hcof.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
    }

    private void checkRecoveryRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            if (this.managedSystem == null || this.resourceType == null) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " and " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(CPU_TYPE)) {
            if (this.managedSystem == null || this.resourceType == null) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(SLOT_TYPE) && (this.managedSystem == null || this.resourceType == null)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.SLOT_ID_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DRAWER_ID_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRecoveryRequiredParameters();
        this.initializeClients();
        this.doRecoverOperation();
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string;
        String string2 = null;
        String string3 = (String)hashMap.get(HMCCommandUtils.SLOT_ID_PARAM);
        if (string3 != null && string3.length() != 0) {
            this.slotId = Short.parseShort(string3);
        }
        if ((string = (String)hashMap.get(HMCCommandUtils.RECOVERY_PROCESSOR_ID_PARAM)) != null && string.length() != 0) {
            this.processorId = Short.parseShort(string);
        }
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        if (!(this.resourceType == null || this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE))) {
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
            throw new RequiredParameterException(string2);
        }
        this.drawerId = (String)hashMap.get(HMCCommandUtils.DRAWER_ID_PARAM);
        this.physLoc = (String)hashMap.get(HMCCommandUtils.PHYSICAL_LOCATION_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.partitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        if (this.managedSystem == null || this.resourceType == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(SLOT_TYPE)) {
            Object[] objectArray = new String[2];
            if (this.physLoc != null && this.drawerId != null && this.slotId != -1) {
                objectArray[0] = HMCCommandUtils.PHYSICAL_LOCATION_PARAM;
                objectArray[1] = HMCCommandUtils.DRAWER_ID_PARAM + ", " + HMCCommandUtils.SLOT_ID_PARAM;
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_CONFLICT_ARGS", null, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RECOVER_RESOURCES_HELP"));
    }

    public static void main(String[] stringArray) {
        PIHscUtil.initHscUtil(3);
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        RecoverResources recoverResources = new RecoverResources();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                recoverResources.printHelp();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                arrayList.add(string2);
                if (!string2.equals(HMCCommandUtils.HELP_PARAM)) continue;
                recoverResources.printHelp();
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                recoverResources.mapParameters(hashMap);
                recoverResources.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            HSCLogUtils.clientLog(hSCException, HSCLogUtils._LPARClassLogInfo);
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            HSCLogUtils.clientLog(exception, HSCLogUtils._LPARClassLogInfo);
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

